 /*-----------------------------------------------------------------------------*
 * File Name: ReportTree.h			 											*
 * Creation: YuI	 															*
 * Purpose: X-Function ReportTree												*
 * Copyright (c) Originlab Corp.	2007										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	ML 7/12/2006 REPORT_DATA_WITH_XF_WORKSHEET_GRAPHS_HANDLING					*
 *	ML 7/17/2006 GETTING_INPUT_DATA_DESCRIPTION_FROM_WITHIN_XFUNCTION_EXECUTION	*
 *	ML 8/24/2006 SET_CELL_FOR_2D_TABLES_REPORTTABLE								*
 *	CPY 4/8/07 MOVE_COMMON_REPORT_TREE_PREP_CODE_TO_GLOBAL_FUNCTION				*
 *	RVD 10/30/2007 v8.0737 qa7-10609 REPORT_FOOTNOTE_STYLE_THEME				*
 *	Sophy 3/16/2009 v8.0956 FIX_AVECURVES_NOT_SHOW_FULL_RANGE_ON_CHANGE_PARAM	*
 *------------------------------------------------------------------------------*/

#ifndef	_REPORTTREE_H
#define	_REPORTTREE_H
#ifdef	REPORT_TREE_VC_BASED


//////////////////////////////////////////////////////////
// class ReportTable
//////////////////////////////////////////////////////////
class ReportBase : public TreeNode
{
public:
	ReportBase(TreeNode& tr);
	
public:
	/// ML 8/24/2006 SET_CELL_FOR_2D_TABLES_REPORTTABLE
	//ReportTable		CreateTable(LPCSTR lpcszTagName, LPCSTR lpcszLabel, int nId);	
	ReportTable		CreateTable(LPCSTR lpcszTagName, LPCSTR lpcszLabel, int nId, int nNumRowLabels = -1, int nNumColumnLabels = -1);	
	/// end SET_CELL_FOR_2D_TABLES_REPORTTABLE
};

class ReportTable : public ReportBase
{
public:
	ReportTable(TreeNode& tr);

public:
	TreeNode 		AddRow(LPCSTR lpcszName, vector& vec, LPCSTR lpcszRowLabel = NULL, vector<string>& vsColLabels = NULL, vector<string>& vsColtagNames = NULL, int nId = 0, LPCSTR lpcszMoreRowLabel = NULL, int index = 0);
	TreeNode 		AddRow(LPCSTR lpcszName, vector<string>& vec, LPCSTR lpcszRowLabel = NULL, vector<string>& vsColLabels = NULL, vector<string>& vsColtagNames = NULL, int nId = 0, LPCSTR lpcszMoreRowLabel = NULL, int index = 0);
	TreeNode 		AddRow(LPCSTR lpcszName, LPCSTR lpcszRowLabel, LPCSTR lpcszValue, int nId = 0);
	TreeNode 		AddRow(LPCSTR lpcszName, LPCSTR lpcszRowLabel, double dValue, int nId = 0);	
	TreeNode 		AddColumn(vector& vec, LPCSTR lpcszName, int nID, LPCSTR lpcszLongName = NULL, int nDesignation = OKDATAOBJ_DESIGNATION_Y);
	TreeNode		AddColumn(vector<string>& vec, LPCSTR lpcszName, int nID, LPCSTR lpcszLongName = NULL, int nDesignation = OKDATAOBJ_DESIGNATION_Y);
	TreeNode		AddColumn(vector<complex>& vec, LPCSTR lpcszName, int nID, LPCSTR lpcszLongName = NULL, int nDesignation = OKDATAOBJ_DESIGNATION_Y);

	/// ML 8/24/2006 SET_CELL_FOR_2D_TABLES_REPORTTABLE
	BOOL			SetCell(int row, int col, double rVal);
	BOOL			SetCell(int row, int col, LPCSTR lpcszValue);
	BOOL			SetCell(int row, int col, GraphPage &gpg, DWORD dwCntrl = 0);
	/// end SET_CELL_FOR_2D_TABLES_REPORTTABLE
};


//////////////////////////////////////////////////////////
// class ReportTreeBase
//////////////////////////////////////////////////////////
class ReportTreeBase : public ReportBase
{
public:
	ReportTreeBase(TreeNode& tr);

public:
	void			GenerateReport(Worksheet& wks, BOOL bHierarchy = TRUE, BOOL bHidden = FALSE);
};

//////////////////////////////////////////////////////////
// class ReportTree
//////////////////////////////////////////////////////////
class	ReportTree	:	public	ReportTreeBase
{
public:
	ReportTree(TreeNode& tr);
	/// RVD 10/30/2007 v8.0737 qa7-10609 REPORT_FOOTNOTE_STYLE_THEME
	int		AddTheme(int nTbaleID, TreeNode& trTheme);
	/// end REPORT_FOOTNOTE_STYLE_THEME
};


//////////////////////////////////////////////////////////
// class ReportData
//////////////////////////////////////////////////////////
class	ReportData	:	public	ReportTreeBase
{
public:
	ReportData(TreeNode& tr);
	
public:
	BOOL	PlotIntoLayer(GraphLayer& gl, int nTableID, TreeNode& trGraphicProperties, int nSourceIndex = -1, BOOL bAddSourcePlot = FALSE);
	BOOL	PlotIntoTreeNode(TreeNode& tr, int nTableID, TreeNode& trGraphicProperties, LPCSTR lpcszTemplate = NULL, int nSourceIndex = -1, BOOL bAddSourcePlot = FALSE);	
	void	SetWorksheet(Worksheet& wks);
	BOOL	GetWorksheet(Worksheet& wks);

	void	SetSource(XYRange& rg);
	
	/// ML 7/12/2006 REPORT_DATA_WITH_XF_WORKSHEET_GRAPHS_HANDLING
	/// ML 7/17/2006 GETTING_INPUT_DATA_DESCRIPTION_FROM_WITHIN_XFUNCTION_EXECUTION
	/*
	int			GetCountGraphs();
	GraphPage	GetGraph(int index);
	GraphPage	RemoveGraph(int index);

	int			SetGraph(GraphPage &gpg, int index = -1);
	bool		IsAddPlots();
	void		SetAddPlots(bool bSet);
	*/
	/// end GETTING_INPUT_DATA_DESCRIPTION_FROM_WITHIN_XFUNCTION_EXECUTION

	/**$
	*/
	///Sophy 3/16/2009 v8.0956 FIX_AVECURVES_NOT_SHOW_FULL_RANGE_ON_CHANGE_PARAM
	//BOOL		GetDataRange(DataRange &dr, int nTableID, int nIDX, int *pnIDY, int nCountIDY = 1, BOOL bMultipleBlocks = TRUE, BOOL bCreateWks = false);	
	BOOL		GetDataRange(DataRange &dr, int nTableID, int nIDX, int *pnIDY, int nCountIDY = 1, BOOL bMultipleBlocks = TRUE, BOOL bCreateWks = false, BOOL bIgnoreRowRange = FALSE);//Sophy, if set bGetFullColRange as true, range will be set as c1, r1, c2, -1(r2)
	///end FIX_AVECURVES_NOT_SHOW_FULL_RANGE_ON_CHANGE_PARAM
	/// end REPORT_DATA_WITH_XF_WORKSHEET_GRAPHS_HANDLING
};
#endif //	REPORT_TREE_VC_BASED

//------- CPY 4/8/07 MOVE_COMMON_REPORT_TREE_PREP_CODE_TO_GLOBAL_FUNCTION
/**$
	Parameters:
		outTree = [output] report tree
		lpcszTitle = [input] title of report
		lpcszName = [input] X-Function name
		lpcszInputName = [input] NULL if Input Data table not needed, otherwise the X-Function variable name for Input data
		trTable = [output] created input data table
*/
bool init_report_tree_common_tables(ReportTree& outTree, LPCSTR lpcszTitle, LPCSTR lpcszName, LPCSTR lpcszInputName=NULL, TreeNode& trTable = NULL);
//-------

#endif //	_REPORTTREE_H